/**
 * \file: grl_os_abstraction.h
 *
 * System call abstraction function.
 *
 * \component: svg_common
 *
 * \author: CSpetzler
 *
 * \copyright: (c) 2003 - 2011 ADIT Corporation
 *
 * This Software is under a dual license (MIT/GPL).
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#ifndef _GRL_OS_ABSTRACTION_H_
#define _GRL_OS_ABSTRACTION_H_

#include "svg_error.h"
#include "grl_dlt_log.h"

#define FLG_WAI_AND	0x00
#define FLG_WAI_OR	0x01

#define FLG_CLR		0x10
#define FLG_BITCLR	0x20

#define TMO_FEVR		-1
#define TMO_POL			 0

typedef unsigned char GRL_flg_wai_mod;

typedef unsigned int GRL_flg_ptn;

typedef void *GRL_lock_id;
typedef void *GRL_evtflg_id;
typedef void *GRL_lock_ios_id;

/**
 * OS abstract function prototype
 */

extern GRL_error GRL_cre_lock(GRL_lock_id *p_lock_id, SVGChar *dsname);
extern GRL_error GRL_del_lock(GRL_lock_id lock_id);
extern GRL_error GRL_wai_lock(GRL_lock_id lock_id);
extern GRL_error GRL_wai_lock_tmo(GRL_lock_id lock_id, SVGInt32 tim);
extern GRL_error GRL_sig_lock(GRL_lock_id lock_id);
extern SVGBoolean GRL_is_locked(GRL_lock_id lock_id);

#ifdef USER_SPACE
/**
 * Event flag functions
 */
extern GRL_error GRL_cre_flg(GRL_evtflg_id *evt_flg);
extern GRL_error GRL_del_flg(GRL_evtflg_id evt_flg);
extern GRL_error GRL_set_flg(GRL_evtflg_id evt_flg, GRL_flg_ptn set_pattern);
extern GRL_error GRL_wai_flg(GRL_evtflg_id evt_flg, GRL_flg_ptn pattern,
			     GRL_flg_wai_mod wait_mode, GRL_flg_ptn *r_ptrn,
			     int wai_time);
extern GRL_error GRL_clr_flg(GRL_evtflg_id evt_flg, GRL_flg_ptn clr_pattern);

#else /*USER_SPACE*/

/* check if single or dualos environment*/
extern unsigned int dualosoff;
extern GRL_error  GRL_cre_lock_ios(GRL_lock_ios_id *p_lock_id, SVGChar *dsname);
extern GRL_error  GRL_del_lock_ios(GRL_lock_ios_id lock_id);
extern GRL_error  GRL_wai_lock_ios(GRL_lock_ios_id lock_id);
extern GRL_error  GRL_sig_lock_ios(GRL_lock_ios_id lock_id);

#endif /*USER_SPACE*/
/**
 * Memory abstraction
 */
extern void *GRL_malloc_1D_resource(long size);
extern void *GRL_realloc_1D_resource(long cur_size, long new_size, void *block);
extern void GRL_free_1D_resource(void *block);

#endif /* _GRL_OS_ABSTRACTION_H_ */
